﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DictionariesAndTuples
{
    class Examples35_37
    {
        public static void IndexerLookup()
        {
            var _cachedUserInfo = new Dictionary<string, UserInfo>();
            string userHandle = "idg10";
            _cachedUserInfo.Add(userHandle, new UserInfo());

            // Listing 5-35
            UserInfo info = _cachedUserInfo[userHandle];
        }

        public static void DictionaryInitializer()
        {
            // Listing 5-36
            var textToNumber = new Dictionary<string, int>
            {
                { "jeden", 1 },
                { "dwa", 2 },
                { "trzy", 3 },
            };

            Console.WriteLine(textToNumber["Two"]);
        }

        public static void DictionaryWithCustomComparer()
        {
            // Listing 5-37
            var textToNumber =
                new Dictionary<string, int>(StringComparer.InvariantCultureIgnoreCase)
                {
                    { "jeden", 1 },
                    { "dwa", 2 },
                    { "trzy", 3 },
                };

            Console.WriteLine(textToNumber["Dwa"]);
            Console.WriteLine(textToNumber["dwa"]);
            Console.WriteLine(textToNumber["DWA"]);
            Console.WriteLine(textToNumber["dwA"]);
        }
    }
}
